// Code generated by ./parse.py -go rv64_a rv64_d rv64_f rv64_i rv64_m rv64_q rv64_zba rv64_zbb rv64_zbs rv_a rv_d rv_f rv_i rv_m rv_q rv_s rv_system rv_v rv_zba rv_zbb rv_zbs rv_zicsr; DO NOT EDIT.
package riscv

import "cmd/internal/obj"

type inst struct {
	opcode uint32
	funct3 uint32
	rs1    uint32
	rs2    uint32
	csr    int64
	funct7 uint32
}

func encode(a obj.As) *inst {
	switch a {
	case AADD:
		return &inst{0x33, 0x0, 0x0, 0x0, 0, 0x0}
	case AADDUW:
		return &inst{0x3b, 0x0, 0x0, 0x0, 128, 0x4}
	case AADDI:
		return &inst{0x13, 0x0, 0x0, 0x0, 0, 0x0}
	case AADDIW:
		return &inst{0x1b, 0x0, 0x0, 0x0, 0, 0x0}
	case AADDW:
		return &inst{0x3b, 0x0, 0x0, 0x0, 0, 0x0}
	case AAMOADDD:
		return &inst{0x2f, 0x3, 0x0, 0x0, 0, 0x0}
	case AAMOADDW:
		return &inst{0x2f, 0x2, 0x0, 0x0, 0, 0x0}
	case AAMOANDD:
		return &inst{0x2f, 0x3, 0x0, 0x0, 1536, 0x30}
	case AAMOANDW:
		return &inst{0x2f, 0x2, 0x0, 0x0, 1536, 0x30}
	case AAMOMAXD:
		return &inst{0x2f, 0x3, 0x0, 0x0, -1536, 0x50}
	case AAMOMAXW:
		return &inst{0x2f, 0x2, 0x0, 0x0, -1536, 0x50}
	case AAMOMAXUD:
		return &inst{0x2f, 0x3, 0x0, 0x0, -512, 0x70}
	case AAMOMAXUW:
		return &inst{0x2f, 0x2, 0x0, 0x0, -512, 0x70}
	case AAMOMIND:
		return &inst{0x2f, 0x3, 0x0, 0x0, -2048, 0x40}
	case AAMOMINW:
		return &inst{0x2f, 0x2, 0x0, 0x0, -2048, 0x40}
	case AAMOMINUD:
		return &inst{0x2f, 0x3, 0x0, 0x0, -1024, 0x60}
	case AAMOMINUW:
		return &inst{0x2f, 0x2, 0x0, 0x0, -1024, 0x60}
	case AAMOORD:
		return &inst{0x2f, 0x3, 0x0, 0x0, 1024, 0x20}
	case AAMOORW:
		return &inst{0x2f, 0x2, 0x0, 0x0, 1024, 0x20}
	case AAMOSWAPD:
		return &inst{0x2f, 0x3, 0x0, 0x0, 128, 0x4}
	case AAMOSWAPW:
		return &inst{0x2f, 0x2, 0x0, 0x0, 128, 0x4}
	case AAMOXORD:
		return &inst{0x2f, 0x3, 0x0, 0x0, 512, 0x10}
	case AAMOXORW:
		return &inst{0x2f, 0x2, 0x0, 0x0, 512, 0x10}
	case AAND:
		return &inst{0x33, 0x7, 0x0, 0x0, 0, 0x0}
	case AANDI:
		return &inst{0x13, 0x7, 0x0, 0x0, 0, 0x0}
	case AANDN:
		return &inst{0x33, 0x7, 0x0, 0x0, 1024, 0x20}
	case AAUIPC:
		return &inst{0x17, 0x0, 0x0, 0x0, 0, 0x0}
	case ABCLR:
		return &inst{0x33, 0x1, 0x0, 0x0, 1152, 0x24}
	case ABCLRI:
		return &inst{0x13, 0x1, 0x0, 0x0, 1152, 0x24}
	case ABEQ:
		return &inst{0x63, 0x0, 0x0, 0x0, 0, 0x0}
	case ABEXT:
		return &inst{0x33, 0x5, 0x0, 0x0, 1152, 0x24}
	case ABEXTI:
		return &inst{0x13, 0x5, 0x0, 0x0, 1152, 0x24}
	case ABGE:
		return &inst{0x63, 0x5, 0x0, 0x0, 0, 0x0}
	case ABGEU:
		return &inst{0x63, 0x7, 0x0, 0x0, 0, 0x0}
	case ABINV:
		return &inst{0x33, 0x1, 0x0, 0x0, 1664, 0x34}
	case ABINVI:
		return &inst{0x13, 0x1, 0x0, 0x0, 1664, 0x34}
	case ABLT:
		return &inst{0x63, 0x4, 0x0, 0x0, 0, 0x0}
	case ABLTU:
		return &inst{0x63, 0x6, 0x0, 0x0, 0, 0x0}
	case ABNE:
		return &inst{0x63, 0x1, 0x0, 0x0, 0, 0x0}
	case ABSET:
		return &inst{0x33, 0x1, 0x0, 0x0, 640, 0x14}
	case ABSETI:
		return &inst{0x13, 0x1, 0x0, 0x0, 640, 0x14}
	case ACLZ:
		return &inst{0x13, 0x1, 0x0, 0x0, 1536, 0x30}
	case ACLZW:
		return &inst{0x1b, 0x1, 0x0, 0x0, 1536, 0x30}
	case ACPOP:
		return &inst{0x13, 0x1, 0x0, 0x2, 1538, 0x30}
	case ACPOPW:
		return &inst{0x1b, 0x1, 0x0, 0x2, 1538, 0x30}
	case ACSRRC:
		return &inst{0x73, 0x3, 0x0, 0x0, 0, 0x0}
	case ACSRRCI:
		return &inst{0x73, 0x7, 0x0, 0x0, 0, 0x0}
	case ACSRRS:
		return &inst{0x73, 0x2, 0x0, 0x0, 0, 0x0}
	case ACSRRSI:
		return &inst{0x73, 0x6, 0x0, 0x0, 0, 0x0}
	case ACSRRW:
		return &inst{0x73, 0x1, 0x0, 0x0, 0, 0x0}
	case ACSRRWI:
		return &inst{0x73, 0x5, 0x0, 0x0, 0, 0x0}
	case ACTZ:
		return &inst{0x13, 0x1, 0x0, 0x1, 1537, 0x30}
	case ACTZW:
		return &inst{0x1b, 0x1, 0x0, 0x1, 1537, 0x30}
	case ADIV:
		return &inst{0x33, 0x4, 0x0, 0x0, 32, 0x1}
	case ADIVU:
		return &inst{0x33, 0x5, 0x0, 0x0, 32, 0x1}
	case ADIVUW:
		return &inst{0x3b, 0x5, 0x0, 0x0, 32, 0x1}
	case ADIVW:
		return &inst{0x3b, 0x4, 0x0, 0x0, 32, 0x1}
	case AEBREAK:
		return &inst{0x73, 0x0, 0x0, 0x1, 1, 0x0}
	case AECALL:
		return &inst{0x73, 0x0, 0x0, 0x0, 0, 0x0}
	case AFADDD:
		return &inst{0x53, 0x0, 0x0, 0x0, 32, 0x1}
	case AFADDQ:
		return &inst{0x53, 0x0, 0x0, 0x0, 96, 0x3}
	case AFADDS:
		return &inst{0x53, 0x0, 0x0, 0x0, 0, 0x0}
	case AFCLASSD:
		return &inst{0x53, 0x1, 0x0, 0x0, -480, 0x71}
	case AFCLASSQ:
		return &inst{0x53, 0x1, 0x0, 0x0, -416, 0x73}
	case AFCLASSS:
		return &inst{0x53, 0x1, 0x0, 0x0, -512, 0x70}
	case AFCVTDL:
		return &inst{0x53, 0x0, 0x0, 0x2, -734, 0x69}
	case AFCVTDLU:
		return &inst{0x53, 0x0, 0x0, 0x3, -733, 0x69}
	case AFCVTDQ:
		return &inst{0x53, 0x0, 0x0, 0x3, 1059, 0x21}
	case AFCVTDS:
		return &inst{0x53, 0x0, 0x0, 0x0, 1056, 0x21}
	case AFCVTDW:
		return &inst{0x53, 0x0, 0x0, 0x0, -736, 0x69}
	case AFCVTDWU:
		return &inst{0x53, 0x0, 0x0, 0x1, -735, 0x69}
	case AFCVTLD:
		return &inst{0x53, 0x0, 0x0, 0x2, -990, 0x61}
	case AFCVTLQ:
		return &inst{0x53, 0x0, 0x0, 0x2, -926, 0x63}
	case AFCVTLS:
		return &inst{0x53, 0x0, 0x0, 0x2, -1022, 0x60}
	case AFCVTLUD:
		return &inst{0x53, 0x0, 0x0, 0x3, -989, 0x61}
	case AFCVTLUQ:
		return &inst{0x53, 0x0, 0x0, 0x3, -925, 0x63}
	case AFCVTLUS:
		return &inst{0x53, 0x0, 0x0, 0x3, -1021, 0x60}
	case AFCVTQD:
		return &inst{0x53, 0x0, 0x0, 0x1, 1121, 0x23}
	case AFCVTQL:
		return &inst{0x53, 0x0, 0x0, 0x2, -670, 0x6b}
	case AFCVTQLU:
		return &inst{0x53, 0x0, 0x0, 0x3, -669, 0x6b}
	case AFCVTQS:
		return &inst{0x53, 0x0, 0x0, 0x0, 1120, 0x23}
	case AFCVTQW:
		return &inst{0x53, 0x0, 0x0, 0x0, -672, 0x6b}
	case AFCVTQWU:
		return &inst{0x53, 0x0, 0x0, 0x1, -671, 0x6b}
	case AFCVTSD:
		return &inst{0x53, 0x0, 0x0, 0x1, 1025, 0x20}
	case AFCVTSL:
		return &inst{0x53, 0x0, 0x0, 0x2, -766, 0x68}
	case AFCVTSLU:
		return &inst{0x53, 0x0, 0x0, 0x3, -765, 0x68}
	case AFCVTSQ:
		return &inst{0x53, 0x0, 0x0, 0x3, 1027, 0x20}
	case AFCVTSW:
		return &inst{0x53, 0x0, 0x0, 0x0, -768, 0x68}
	case AFCVTSWU:
		return &inst{0x53, 0x0, 0x0, 0x1, -767, 0x68}
	case AFCVTWD:
		return &inst{0x53, 0x0, 0x0, 0x0, -992, 0x61}
	case AFCVTWQ:
		return &inst{0x53, 0x0, 0x0, 0x0, -928, 0x63}
	case AFCVTWS:
		return &inst{0x53, 0x0, 0x0, 0x0, -1024, 0x60}
	case AFCVTWUD:
		return &inst{0x53, 0x0, 0x0, 0x1, -991, 0x61}
	case AFCVTWUQ:
		return &inst{0x53, 0x0, 0x0, 0x1, -927, 0x63}
	case AFCVTWUS:
		return &inst{0x53, 0x0, 0x0, 0x1, -1023, 0x60}
	case AFDIVD:
		return &inst{0x53, 0x0, 0x0, 0x0, 416, 0xd}
	case AFDIVQ:
		return &inst{0x53, 0x0, 0x0, 0x0, 480, 0xf}
	case AFDIVS:
		return &inst{0x53, 0x0, 0x0, 0x0, 384, 0xc}
	case AFENCE:
		return &inst{0xf, 0x0, 0x0, 0x0, 0, 0x0}
	case AFEQD:
		return &inst{0x53, 0x2, 0x0, 0x0, -1504, 0x51}
	case AFEQQ:
		return &inst{0x53, 0x2, 0x0, 0x0, -1440, 0x53}
	case AFEQS:
		return &inst{0x53, 0x2, 0x0, 0x0, -1536, 0x50}
	case AFLD:
		return &inst{0x7, 0x3, 0x0, 0x0, 0, 0x0}
	case AFLED:
		return &inst{0x53, 0x0, 0x0, 0x0, -1504, 0x51}
	case AFLEQ:
		return &inst{0x53, 0x0, 0x0, 0x0, -1440, 0x53}
	case AFLES:
		return &inst{0x53, 0x0, 0x0, 0x0, -1536, 0x50}
	case AFLQ:
		return &inst{0x7, 0x4, 0x0, 0x0, 0, 0x0}
	case AFLTD:
		return &inst{0x53, 0x1, 0x0, 0x0, -1504, 0x51}
	case AFLTQ:
		return &inst{0x53, 0x1, 0x0, 0x0, -1440, 0x53}
	case AFLTS:
		return &inst{0x53, 0x1, 0x0, 0x0, -1536, 0x50}
	case AFLW:
		return &inst{0x7, 0x2, 0x0, 0x0, 0, 0x0}
	case AFMADDD:
		return &inst{0x43, 0x0, 0x0, 0x0, 32, 0x1}
	case AFMADDQ:
		return &inst{0x43, 0x0, 0x0, 0x0, 96, 0x3}
	case AFMADDS:
		return &inst{0x43, 0x0, 0x0, 0x0, 0, 0x0}
	case AFMAXD:
		return &inst{0x53, 0x1, 0x0, 0x0, 672, 0x15}
	case AFMAXQ:
		return &inst{0x53, 0x1, 0x0, 0x0, 736, 0x17}
	case AFMAXS:
		return &inst{0x53, 0x1, 0x0, 0x0, 640, 0x14}
	case AFMIND:
		return &inst{0x53, 0x0, 0x0, 0x0, 672, 0x15}
	case AFMINQ:
		return &inst{0x53, 0x0, 0x0, 0x0, 736, 0x17}
	case AFMINS:
		return &inst{0x53, 0x0, 0x0, 0x0, 640, 0x14}
	case AFMSUBD:
		return &inst{0x47, 0x0, 0x0, 0x0, 32, 0x1}
	case AFMSUBQ:
		return &inst{0x47, 0x0, 0x0, 0x0, 96, 0x3}
	case AFMSUBS:
		return &inst{0x47, 0x0, 0x0, 0x0, 0, 0x0}
	case AFMULD:
		return &inst{0x53, 0x0, 0x0, 0x0, 288, 0x9}
	case AFMULQ:
		return &inst{0x53, 0x0, 0x0, 0x0, 352, 0xb}
	case AFMULS:
		return &inst{0x53, 0x0, 0x0, 0x0, 256, 0x8}
	case AFMVDX:
		return &inst{0x53, 0x0, 0x0, 0x0, -224, 0x79}
	case AFMVWX:
		return &inst{0x53, 0x0, 0x0, 0x0, -256, 0x78}
	case AFMVXD:
		return &inst{0x53, 0x0, 0x0, 0x0, -480, 0x71}
	case AFMVXW:
		return &inst{0x53, 0x0, 0x0, 0x0, -512, 0x70}
	case AFNMADDD:
		return &inst{0x4f, 0x0, 0x0, 0x0, 32, 0x1}
	case AFNMADDQ:
		return &inst{0x4f, 0x0, 0x0, 0x0, 96, 0x3}
	case AFNMADDS:
		return &inst{0x4f, 0x0, 0x0, 0x0, 0, 0x0}
	case AFNMSUBD:
		return &inst{0x4b, 0x0, 0x0, 0x0, 32, 0x1}
	case AFNMSUBQ:
		return &inst{0x4b, 0x0, 0x0, 0x0, 96, 0x3}
	case AFNMSUBS:
		return &inst{0x4b, 0x0, 0x0, 0x0, 0, 0x0}
	case AFSD:
		return &inst{0x27, 0x3, 0x0, 0x0, 0, 0x0}
	case AFSGNJD:
		return &inst{0x53, 0x0, 0x0, 0x0, 544, 0x11}
	case AFSGNJQ:
		return &inst{0x53, 0x0, 0x0, 0x0, 608, 0x13}
	case AFSGNJS:
		return &inst{0x53, 0x0, 0x0, 0x0, 512, 0x10}
	case AFSGNJND:
		return &inst{0x53, 0x1, 0x0, 0x0, 544, 0x11}
	case AFSGNJNQ:
		return &inst{0x53, 0x1, 0x0, 0x0, 608, 0x13}
	case AFSGNJNS:
		return &inst{0x53, 0x1, 0x0, 0x0, 512, 0x10}
	case AFSGNJXD:
		return &inst{0x53, 0x2, 0x0, 0x0, 544, 0x11}
	case AFSGNJXQ:
		return &inst{0x53, 0x2, 0x0, 0x0, 608, 0x13}
	case AFSGNJXS:
		return &inst{0x53, 0x2, 0x0, 0x0, 512, 0x10}
	case AFSQ:
		return &inst{0x27, 0x4, 0x0, 0x0, 0, 0x0}
	case AFSQRTD:
		return &inst{0x53, 0x0, 0x0, 0x0, 1440, 0x2d}
	case AFSQRTQ:
		return &inst{0x53, 0x0, 0x0, 0x0, 1504, 0x2f}
	case AFSQRTS:
		return &inst{0x53, 0x0, 0x0, 0x0, 1408, 0x2c}
	case AFSUBD:
		return &inst{0x53, 0x0, 0x0, 0x0, 160, 0x5}
	case AFSUBQ:
		return &inst{0x53, 0x0, 0x0, 0x0, 224, 0x7}
	case AFSUBS:
		return &inst{0x53, 0x0, 0x0, 0x0, 128, 0x4}
	case AFSW:
		return &inst{0x27, 0x2, 0x0, 0x0, 0, 0x0}
	case AJAL:
		return &inst{0x6f, 0x0, 0x0, 0x0, 0, 0x0}
	case AJALR:
		return &inst{0x67, 0x0, 0x0, 0x0, 0, 0x0}
	case ALB:
		return &inst{0x3, 0x0, 0x0, 0x0, 0, 0x0}
	case ALBU:
		return &inst{0x3, 0x4, 0x0, 0x0, 0, 0x0}
	case ALD:
		return &inst{0x3, 0x3, 0x0, 0x0, 0, 0x0}
	case ALH:
		return &inst{0x3, 0x1, 0x0, 0x0, 0, 0x0}
	case ALHU:
		return &inst{0x3, 0x5, 0x0, 0x0, 0, 0x0}
	case ALRD:
		return &inst{0x2f, 0x3, 0x0, 0x0, 256, 0x8}
	case ALRW:
		return &inst{0x2f, 0x2, 0x0, 0x0, 256, 0x8}
	case ALUI:
		return &inst{0x37, 0x0, 0x0, 0x0, 0, 0x0}
	case ALW:
		return &inst{0x3, 0x2, 0x0, 0x0, 0, 0x0}
	case ALWU:
		return &inst{0x3, 0x6, 0x0, 0x0, 0, 0x0}
	case AMAX:
		return &inst{0x33, 0x6, 0x0, 0x0, 160, 0x5}
	case AMAXU:
		return &inst{0x33, 0x7, 0x0, 0x0, 160, 0x5}
	case AMIN:
		return &inst{0x33, 0x4, 0x0, 0x0, 160, 0x5}
	case AMINU:
		return &inst{0x33, 0x5, 0x0, 0x0, 160, 0x5}
	case AMRET:
		return &inst{0x73, 0x0, 0x0, 0x2, 770, 0x18}
	case AMUL:
		return &inst{0x33, 0x0, 0x0, 0x0, 32, 0x1}
	case AMULH:
		return &inst{0x33, 0x1, 0x0, 0x0, 32, 0x1}
	case AMULHSU:
		return &inst{0x33, 0x2, 0x0, 0x0, 32, 0x1}
	case AMULHU:
		return &inst{0x33, 0x3, 0x0, 0x0, 32, 0x1}
	case AMULW:
		return &inst{0x3b, 0x0, 0x0, 0x0, 32, 0x1}
	case AOR:
		return &inst{0x33, 0x6, 0x0, 0x0, 0, 0x0}
	case AORCB:
		return &inst{0x13, 0x5, 0x0, 0x7, 647, 0x14}
	case AORI:
		return &inst{0x13, 0x6, 0x0, 0x0, 0, 0x0}
	case AORN:
		return &inst{0x33, 0x6, 0x0, 0x0, 1024, 0x20}
	case AREM:
		return &inst{0x33, 0x6, 0x0, 0x0, 32, 0x1}
	case AREMU:
		return &inst{0x33, 0x7, 0x0, 0x0, 32, 0x1}
	case AREMUW:
		return &inst{0x3b, 0x7, 0x0, 0x0, 32, 0x1}
	case AREMW:
		return &inst{0x3b, 0x6, 0x0, 0x0, 32, 0x1}
	case AREV8:
		return &inst{0x13, 0x5, 0x0, 0x18, 1720, 0x35}
	case AROL:
		return &inst{0x33, 0x1, 0x0, 0x0, 1536, 0x30}
	case AROLW:
		return &inst{0x3b, 0x1, 0x0, 0x0, 1536, 0x30}
	case AROR:
		return &inst{0x33, 0x5, 0x0, 0x0, 1536, 0x30}
	case ARORI:
		return &inst{0x13, 0x5, 0x0, 0x0, 1536, 0x30}
	case ARORIW:
		return &inst{0x1b, 0x5, 0x0, 0x0, 1536, 0x30}
	case ARORW:
		return &inst{0x3b, 0x5, 0x0, 0x0, 1536, 0x30}
	case ASB:
		return &inst{0x23, 0x0, 0x0, 0x0, 0, 0x0}
	case ASCD:
		return &inst{0x2f, 0x3, 0x0, 0x0, 384, 0xc}
	case ASCW:
		return &inst{0x2f, 0x2, 0x0, 0x0, 384, 0xc}
	case ASD:
		return &inst{0x23, 0x3, 0x0, 0x0, 0, 0x0}
	case ASEXTB:
		return &inst{0x13, 0x1, 0x0, 0x4, 1540, 0x30}
	case ASEXTH:
		return &inst{0x13, 0x1, 0x0, 0x5, 1541, 0x30}
	case ASFENCEVMA:
		return &inst{0x73, 0x0, 0x0, 0x0, 288, 0x9}
	case ASH:
		return &inst{0x23, 0x1, 0x0, 0x0, 0, 0x0}
	case ASH1ADD:
		return &inst{0x33, 0x2, 0x0, 0x0, 512, 0x10}
	case ASH1ADDUW:
		return &inst{0x3b, 0x2, 0x0, 0x0, 512, 0x10}
	case ASH2ADD:
		return &inst{0x33, 0x4, 0x0, 0x0, 512, 0x10}
	case ASH2ADDUW:
		return &inst{0x3b, 0x4, 0x0, 0x0, 512, 0x10}
	case ASH3ADD:
		return &inst{0x33, 0x6, 0x0, 0x0, 512, 0x10}
	case ASH3ADDUW:
		return &inst{0x3b, 0x6, 0x0, 0x0, 512, 0x10}
	case ASLL:
		return &inst{0x33, 0x1, 0x0, 0x0, 0, 0x0}
	case ASLLI:
		return &inst{0x13, 0x1, 0x0, 0x0, 0, 0x0}
	case ASLLIUW:
		return &inst{0x1b, 0x1, 0x0, 0x0, 128, 0x4}
	case ASLLIW:
		return &inst{0x1b, 0x1, 0x0, 0x0, 0, 0x0}
	case ASLLW:
		return &inst{0x3b, 0x1, 0x0, 0x0, 0, 0x0}
	case ASLT:
		return &inst{0x33, 0x2, 0x0, 0x0, 0, 0x0}
	case ASLTI:
		return &inst{0x13, 0x2, 0x0, 0x0, 0, 0x0}
	case ASLTIU:
		return &inst{0x13, 0x3, 0x0, 0x0, 0, 0x0}
	case ASLTU:
		return &inst{0x33, 0x3, 0x0, 0x0, 0, 0x0}
	case ASRA:
		return &inst{0x33, 0x5, 0x0, 0x0, 1024, 0x20}
	case ASRAI:
		return &inst{0x13, 0x5, 0x0, 0x0, 1024, 0x20}
	case ASRAIW:
		return &inst{0x1b, 0x5, 0x0, 0x0, 1024, 0x20}
	case ASRAW:
		return &inst{0x3b, 0x5, 0x0, 0x0, 1024, 0x20}
	case ASRET:
		return &inst{0x73, 0x0, 0x0, 0x2, 258, 0x8}
	case ASRL:
		return &inst{0x33, 0x5, 0x0, 0x0, 0, 0x0}
	case ASRLI:
		return &inst{0x13, 0x5, 0x0, 0x0, 0, 0x0}
	case ASRLIW:
		return &inst{0x1b, 0x5, 0x0, 0x0, 0, 0x0}
	case ASRLW:
		return &inst{0x3b, 0x5, 0x0, 0x0, 0, 0x0}
	case ASUB:
		return &inst{0x33, 0x0, 0x0, 0x0, 1024, 0x20}
	case ASUBW:
		return &inst{0x3b, 0x0, 0x0, 0x0, 1024, 0x20}
	case ASW:
		return &inst{0x23, 0x2, 0x0, 0x0, 0, 0x0}
	case AVAADDVV:
		return &inst{0x57, 0x2, 0x0, 0x0, 576, 0x12}
	case AVAADDVX:
		return &inst{0x57, 0x6, 0x0, 0x0, 576, 0x12}
	case AVAADDUVV:
		return &inst{0x57, 0x2, 0x0, 0x0, 512, 0x10}
	case AVAADDUVX:
		return &inst{0x57, 0x6, 0x0, 0x0, 512, 0x10}
	case AVADCVIM:
		return &inst{0x57, 0x3, 0x0, 0x0, 1024, 0x20}
	case AVADCVVM:
		return &inst{0x57, 0x0, 0x0, 0x0, 1024, 0x20}
	case AVADCVXM:
		return &inst{0x57, 0x4, 0x0, 0x0, 1024, 0x20}
	case AVADDVI:
		return &inst{0x57, 0x3, 0x0, 0x0, 0, 0x0}
	case AVADDVV:
		return &inst{0x57, 0x0, 0x0, 0x0, 0, 0x0}
	case AVADDVX:
		return &inst{0x57, 0x4, 0x0, 0x0, 0, 0x0}
	case AVANDVI:
		return &inst{0x57, 0x3, 0x0, 0x0, 576, 0x12}
	case AVANDVV:
		return &inst{0x57, 0x0, 0x0, 0x0, 576, 0x12}
	case AVANDVX:
		return &inst{0x57, 0x4, 0x0, 0x0, 576, 0x12}
	case AVASUBVV:
		return &inst{0x57, 0x2, 0x0, 0x0, 704, 0x16}
	case AVASUBVX:
		return &inst{0x57, 0x6, 0x0, 0x0, 704, 0x16}
	case AVASUBUVV:
		return &inst{0x57, 0x2, 0x0, 0x0, 640, 0x14}
	case AVASUBUVX:
		return &inst{0x57, 0x6, 0x0, 0x0, 640, 0x14}
	case AVCOMPRESSVM:
		return &inst{0x57, 0x2, 0x0, 0x0, 1504, 0x2f}
	case AVCPOPM:
		return &inst{0x57, 0x2, 0x10, 0x0, 1024, 0x20}
	case AVDIVVV:
		return &inst{0x57, 0x2, 0x0, 0x0, -1984, 0x42}
	case AVDIVVX:
		return &inst{0x57, 0x6, 0x0, 0x0, -1984, 0x42}
	case AVDIVUVV:
		return &inst{0x57, 0x2, 0x0, 0x0, -2048, 0x40}
	case AVDIVUVX:
		return &inst{0x57, 0x6, 0x0, 0x0, -2048, 0x40}
	case AVFADDVF:
		return &inst{0x57, 0x5, 0x0, 0x0, 0, 0x0}
	case AVFADDVV:
		return &inst{0x57, 0x1, 0x0, 0x0, 0, 0x0}
	case AVFCLASSV:
		return &inst{0x57, 0x1, 0x10, 0x0, 1216, 0x26}
	case AVFCVTFXV:
		return &inst{0x57, 0x1, 0x3, 0x0, 1152, 0x24}
	case AVFCVTFXUV:
		return &inst{0x57, 0x1, 0x2, 0x0, 1152, 0x24}
	case AVFCVTRTZXFV:
		return &inst{0x57, 0x1, 0x7, 0x0, 1152, 0x24}
	case AVFCVTRTZXUFV:
		return &inst{0x57, 0x1, 0x6, 0x0, 1152, 0x24}
	case AVFCVTXFV:
		return &inst{0x57, 0x1, 0x1, 0x0, 1152, 0x24}
	case AVFCVTXUFV:
		return &inst{0x57, 0x1, 0x0, 0x0, 1152, 0x24}
	case AVFDIVVF:
		return &inst{0x57, 0x5, 0x0, 0x0, -2048, 0x40}
	case AVFDIVVV:
		return &inst{0x57, 0x1, 0x0, 0x0, -2048, 0x40}
	case AVFIRSTM:
		return &inst{0x57, 0x2, 0x11, 0x0, 1024, 0x20}
	case AVFMACCVF:
		return &inst{0x57, 0x5, 0x0, 0x0, -1280, 0x58}
	case AVFMACCVV:
		return &inst{0x57, 0x1, 0x0, 0x0, -1280, 0x58}
	case AVFMADDVF:
		return &inst{0x57, 0x5, 0x0, 0x0, -1536, 0x50}
	case AVFMADDVV:
		return &inst{0x57, 0x1, 0x0, 0x0, -1536, 0x50}
	case AVFMAXVF:
		return &inst{0x57, 0x5, 0x0, 0x0, 384, 0xc}
	case AVFMAXVV:
		return &inst{0x57, 0x1, 0x0, 0x0, 384, 0xc}
	case AVFMERGEVFM:
		return &inst{0x57, 0x5, 0x0, 0x0, 1472, 0x2e}
	case AVFMINVF:
		return &inst{0x57, 0x5, 0x0, 0x0, 256, 0x8}
	case AVFMINVV:
		return &inst{0x57, 0x1, 0x0, 0x0, 256, 0x8}
	case AVFMSACVF:
		return &inst{0x57, 0x5, 0x0, 0x0, -1152, 0x5c}
	case AVFMSACVV:
		return &inst{0x57, 0x1, 0x0, 0x0, -1152, 0x5c}
	case AVFMSUBVF:
		return &inst{0x57, 0x5, 0x0, 0x0, -1408, 0x54}
	case AVFMSUBVV:
		return &inst{0x57, 0x1, 0x0, 0x0, -1408, 0x54}
	case AVFMULVF:
		return &inst{0x57, 0x5, 0x0, 0x0, -1792, 0x48}
	case AVFMULVV:
		return &inst{0x57, 0x1, 0x0, 0x0, -1792, 0x48}
	case AVFMVFS:
		return &inst{0x57, 0x1, 0x0, 0x0, 1056, 0x21}
	case AVFMVSF:
		return &inst{0x57, 0x5, 0x0, 0x0, 1056, 0x21}
	case AVFMVVF:
		return &inst{0x57, 0x5, 0x0, 0x0, 1504, 0x2f}
	case AVFNCVTFFW:
		return &inst{0x57, 0x1, 0x14, 0x0, 1152, 0x24}
	case AVFNCVTFXW:
		return &inst{0x57, 0x1, 0x13, 0x0, 1152, 0x24}
	case AVFNCVTFXUW:
		return &inst{0x57, 0x1, 0x12, 0x0, 1152, 0x24}
	case AVFNCVTRODFFW:
		return &inst{0x57, 0x1, 0x15, 0x0, 1152, 0x24}
	case AVFNCVTRTZXFW:
		return &inst{0x57, 0x1, 0x17, 0x0, 1152, 0x24}
	case AVFNCVTRTZXUFW:
		return &inst{0x57, 0x1, 0x16, 0x0, 1152, 0x24}
	case AVFNCVTXFW:
		return &inst{0x57, 0x1, 0x11, 0x0, 1152, 0x24}
	case AVFNCVTXUFW:
		return &inst{0x57, 0x1, 0x10, 0x0, 1152, 0x24}
	case AVFNMACCVF:
		return &inst{0x57, 0x5, 0x0, 0x0, -1216, 0x5a}
	case AVFNMACCVV:
		return &inst{0x57, 0x1, 0x0, 0x0, -1216, 0x5a}
	case AVFNMADDVF:
		return &inst{0x57, 0x5, 0x0, 0x0, -1472, 0x52}
	case AVFNMADDVV:
		return &inst{0x57, 0x1, 0x0, 0x0, -1472, 0x52}
	case AVFNMSACVF:
		return &inst{0x57, 0x5, 0x0, 0x0, -1088, 0x5e}
	case AVFNMSACVV:
		return &inst{0x57, 0x1, 0x0, 0x0, -1088, 0x5e}
	case AVFNMSUBVF:
		return &inst{0x57, 0x5, 0x0, 0x0, -1344, 0x56}
	case AVFNMSUBVV:
		return &inst{0x57, 0x1, 0x0, 0x0, -1344, 0x56}
	case AVFRDIVVF:
		return &inst{0x57, 0x5, 0x0, 0x0, -1984, 0x42}
	case AVFREC7V:
		return &inst{0x57, 0x1, 0x5, 0x0, 1216, 0x26}
	case AVFREDMAXVS:
		return &inst{0x57, 0x1, 0x0, 0x0, 448, 0xe}
	case AVFREDMINVS:
		return &inst{0x57, 0x1, 0x0, 0x0, 320, 0xa}
	case AVFREDOSUMVS:
		return &inst{0x57, 0x1, 0x0, 0x0, 192, 0x6}
	case AVFREDUSUMVS:
		return &inst{0x57, 0x1, 0x0, 0x0, 64, 0x2}
	case AVFRSQRT7V:
		return &inst{0x57, 0x1, 0x4, 0x0, 1216, 0x26}
	case AVFRSUBVF:
		return &inst{0x57, 0x5, 0x0, 0x0, -1600, 0x4e}
	case AVFSGNJVF:
		return &inst{0x57, 0x5, 0x0, 0x0, 512, 0x10}
	case AVFSGNJVV:
		return &inst{0x57, 0x1, 0x0, 0x0, 512, 0x10}
	case AVFSGNJNVF:
		return &inst{0x57, 0x5, 0x0, 0x0, 576, 0x12}
	case AVFSGNJNVV:
		return &inst{0x57, 0x1, 0x0, 0x0, 576, 0x12}
	case AVFSGNJXVF:
		return &inst{0x57, 0x5, 0x0, 0x0, 640, 0x14}
	case AVFSGNJXVV:
		return &inst{0x57, 0x1, 0x0, 0x0, 640, 0x14}
	case AVFSLIDE1DOWNVF:
		return &inst{0x57, 0x5, 0x0, 0x0, 960, 0x1e}
	case AVFSLIDE1UPVF:
		return &inst{0x57, 0x5, 0x0, 0x0, 896, 0x1c}
	case AVFSQRTV:
		return &inst{0x57, 0x1, 0x0, 0x0, 1216, 0x26}
	case AVFSUBVF:
		return &inst{0x57, 0x5, 0x0, 0x0, 128, 0x4}
	case AVFSUBVV:
		return &inst{0x57, 0x1, 0x0, 0x0, 128, 0x4}
	case AVFWADDVF:
		return &inst{0x57, 0x5, 0x0, 0x0, -1024, 0x60}
	case AVFWADDVV:
		return &inst{0x57, 0x1, 0x0, 0x0, -1024, 0x60}
	case AVFWADDWF:
		return &inst{0x57, 0x5, 0x0, 0x0, -768, 0x68}
	case AVFWADDWV:
		return &inst{0x57, 0x1, 0x0, 0x0, -768, 0x68}
	case AVFWCVTFFV:
		return &inst{0x57, 0x1, 0xc, 0x0, 1152, 0x24}
	case AVFWCVTFXV:
		return &inst{0x57, 0x1, 0xb, 0x0, 1152, 0x24}
	case AVFWCVTFXUV:
		return &inst{0x57, 0x1, 0xa, 0x0, 1152, 0x24}
	case AVFWCVTRTZXFV:
		return &inst{0x57, 0x1, 0xf, 0x0, 1152, 0x24}
	case AVFWCVTRTZXUFV:
		return &inst{0x57, 0x1, 0xe, 0x0, 1152, 0x24}
	case AVFWCVTXFV:
		return &inst{0x57, 0x1, 0x9, 0x0, 1152, 0x24}
	case AVFWCVTXUFV:
		return &inst{0x57, 0x1, 0x8, 0x0, 1152, 0x24}
	case AVFWMACCVF:
		return &inst{0x57, 0x5, 0x0, 0x0, -256, 0x78}
	case AVFWMACCVV:
		return &inst{0x57, 0x1, 0x0, 0x0, -256, 0x78}
	case AVFWMSACVF:
		return &inst{0x57, 0x5, 0x0, 0x0, -128, 0x7c}
	case AVFWMSACVV:
		return &inst{0x57, 0x1, 0x0, 0x0, -128, 0x7c}
	case AVFWMULVF:
		return &inst{0x57, 0x5, 0x0, 0x0, -512, 0x70}
	case AVFWMULVV:
		return &inst{0x57, 0x1, 0x0, 0x0, -512, 0x70}
	case AVFWNMACCVF:
		return &inst{0x57, 0x5, 0x0, 0x0, -192, 0x7a}
	case AVFWNMACCVV:
		return &inst{0x57, 0x1, 0x0, 0x0, -192, 0x7a}
	case AVFWNMSACVF:
		return &inst{0x57, 0x5, 0x0, 0x0, -64, 0x7e}
	case AVFWNMSACVV:
		return &inst{0x57, 0x1, 0x0, 0x0, -64, 0x7e}
	case AVFWREDOSUMVS:
		return &inst{0x57, 0x1, 0x0, 0x0, -832, 0x66}
	case AVFWREDUSUMVS:
		return &inst{0x57, 0x1, 0x0, 0x0, -960, 0x62}
	case AVFWSUBVF:
		return &inst{0x57, 0x5, 0x0, 0x0, -896, 0x64}
	case AVFWSUBVV:
		return &inst{0x57, 0x1, 0x0, 0x0, -896, 0x64}
	case AVFWSUBWF:
		return &inst{0x57, 0x5, 0x0, 0x0, -640, 0x6c}
	case AVFWSUBWV:
		return &inst{0x57, 0x1, 0x0, 0x0, -640, 0x6c}
	case AVIDV:
		return &inst{0x57, 0x2, 0x11, 0x0, 1280, 0x28}
	case AVIOTAM:
		return &inst{0x57, 0x2, 0x10, 0x0, 1280, 0x28}
	case AVL1RE16V:
		return &inst{0x7, 0x5, 0x0, 0x8, 40, 0x1}
	case AVL1RE32V:
		return &inst{0x7, 0x6, 0x0, 0x8, 40, 0x1}
	case AVL1RE64V:
		return &inst{0x7, 0x7, 0x0, 0x8, 40, 0x1}
	case AVL1RE8V:
		return &inst{0x7, 0x0, 0x0, 0x8, 40, 0x1}
	case AVL2RE16V:
		return &inst{0x7, 0x5, 0x0, 0x8, 552, 0x11}
	case AVL2RE32V:
		return &inst{0x7, 0x6, 0x0, 0x8, 552, 0x11}
	case AVL2RE64V:
		return &inst{0x7, 0x7, 0x0, 0x8, 552, 0x11}
	case AVL2RE8V:
		return &inst{0x7, 0x0, 0x0, 0x8, 552, 0x11}
	case AVL4RE16V:
		return &inst{0x7, 0x5, 0x0, 0x8, 1576, 0x31}
	case AVL4RE32V:
		return &inst{0x7, 0x6, 0x0, 0x8, 1576, 0x31}
	case AVL4RE64V:
		return &inst{0x7, 0x7, 0x0, 0x8, 1576, 0x31}
	case AVL4RE8V:
		return &inst{0x7, 0x0, 0x0, 0x8, 1576, 0x31}
	case AVL8RE16V:
		return &inst{0x7, 0x5, 0x0, 0x8, -472, 0x71}
	case AVL8RE32V:
		return &inst{0x7, 0x6, 0x0, 0x8, -472, 0x71}
	case AVL8RE64V:
		return &inst{0x7, 0x7, 0x0, 0x8, -472, 0x71}
	case AVL8RE8V:
		return &inst{0x7, 0x0, 0x0, 0x8, -472, 0x71}
	case AVLE16V:
		return &inst{0x7, 0x5, 0x0, 0x0, 0, 0x0}
	case AVLE16FFV:
		return &inst{0x7, 0x5, 0x0, 0x10, 16, 0x0}
	case AVLE32V:
		return &inst{0x7, 0x6, 0x0, 0x0, 0, 0x0}
	case AVLE32FFV:
		return &inst{0x7, 0x6, 0x0, 0x10, 16, 0x0}
	case AVLE64V:
		return &inst{0x7, 0x7, 0x0, 0x0, 0, 0x0}
	case AVLE64FFV:
		return &inst{0x7, 0x7, 0x0, 0x10, 16, 0x0}
	case AVLE8V:
		return &inst{0x7, 0x0, 0x0, 0x0, 0, 0x0}
	case AVLE8FFV:
		return &inst{0x7, 0x0, 0x0, 0x10, 16, 0x0}
	case AVLMV:
		return &inst{0x7, 0x0, 0x0, 0xb, 43, 0x1}
	case AVLOXEI16V:
		return &inst{0x7, 0x5, 0x0, 0x0, 192, 0x6}
	case AVLOXEI32V:
		return &inst{0x7, 0x6, 0x0, 0x0, 192, 0x6}
	case AVLOXEI64V:
		return &inst{0x7, 0x7, 0x0, 0x0, 192, 0x6}
	case AVLOXEI8V:
		return &inst{0x7, 0x0, 0x0, 0x0, 192, 0x6}
	case AVLSE16V:
		return &inst{0x7, 0x5, 0x0, 0x0, 128, 0x4}
	case AVLSE32V:
		return &inst{0x7, 0x6, 0x0, 0x0, 128, 0x4}
	case AVLSE64V:
		return &inst{0x7, 0x7, 0x0, 0x0, 128, 0x4}
	case AVLSE8V:
		return &inst{0x7, 0x0, 0x0, 0x0, 128, 0x4}
	case AVLUXEI16V:
		return &inst{0x7, 0x5, 0x0, 0x0, 64, 0x2}
	case AVLUXEI32V:
		return &inst{0x7, 0x6, 0x0, 0x0, 64, 0x2}
	case AVLUXEI64V:
		return &inst{0x7, 0x7, 0x0, 0x0, 64, 0x2}
	case AVLUXEI8V:
		return &inst{0x7, 0x0, 0x0, 0x0, 64, 0x2}
	case AVMACCVV:
		return &inst{0x57, 0x2, 0x0, 0x0, -1216, 0x5a}
	case AVMACCVX:
		return &inst{0x57, 0x6, 0x0, 0x0, -1216, 0x5a}
	case AVMADCVI:
		return &inst{0x57, 0x3, 0x0, 0x0, 1120, 0x23}
	case AVMADCVIM:
		return &inst{0x57, 0x3, 0x0, 0x0, 1088, 0x22}
	case AVMADCVV:
		return &inst{0x57, 0x0, 0x0, 0x0, 1120, 0x23}
	case AVMADCVVM:
		return &inst{0x57, 0x0, 0x0, 0x0, 1088, 0x22}
	case AVMADCVX:
		return &inst{0x57, 0x4, 0x0, 0x0, 1120, 0x23}
	case AVMADCVXM:
		return &inst{0x57, 0x4, 0x0, 0x0, 1088, 0x22}
	case AVMADDVV:
		return &inst{0x57, 0x2, 0x0, 0x0, -1472, 0x52}
	case AVMADDVX:
		return &inst{0x57, 0x6, 0x0, 0x0, -1472, 0x52}
	case AVMANDMM:
		return &inst{0x57, 0x2, 0x0, 0x0, 1632, 0x33}
	case AVMANDNMM:
		return &inst{0x57, 0x2, 0x0, 0x0, 1568, 0x31}
	case AVMAXVV:
		return &inst{0x57, 0x0, 0x0, 0x0, 448, 0xe}
	case AVMAXVX:
		return &inst{0x57, 0x4, 0x0, 0x0, 448, 0xe}
	case AVMAXUVV:
		return &inst{0x57, 0x0, 0x0, 0x0, 384, 0xc}
	case AVMAXUVX:
		return &inst{0x57, 0x4, 0x0, 0x0, 384, 0xc}
	case AVMERGEVIM:
		return &inst{0x57, 0x3, 0x0, 0x0, 1472, 0x2e}
	case AVMERGEVVM:
		return &inst{0x57, 0x0, 0x0, 0x0, 1472, 0x2e}
	case AVMERGEVXM:
		return &inst{0x57, 0x4, 0x0, 0x0, 1472, 0x2e}
	case AVMFEQVF:
		return &inst{0x57, 0x5, 0x0, 0x0, 1536, 0x30}
	case AVMFEQVV:
		return &inst{0x57, 0x1, 0x0, 0x0, 1536, 0x30}
	case AVMFGEVF:
		return &inst{0x57, 0x5, 0x0, 0x0, 1984, 0x3e}
	case AVMFGTVF:
		return &inst{0x57, 0x5, 0x0, 0x0, 1856, 0x3a}
	case AVMFLEVF:
		return &inst{0x57, 0x5, 0x0, 0x0, 1600, 0x32}
	case AVMFLEVV:
		return &inst{0x57, 0x1, 0x0, 0x0, 1600, 0x32}
	case AVMFLTVF:
		return &inst{0x57, 0x5, 0x0, 0x0, 1728, 0x36}
	case AVMFLTVV:
		return &inst{0x57, 0x1, 0x0, 0x0, 1728, 0x36}
	case AVMFNEVF:
		return &inst{0x57, 0x5, 0x0, 0x0, 1792, 0x38}
	case AVMFNEVV:
		return &inst{0x57, 0x1, 0x0, 0x0, 1792, 0x38}
	case AVMINVV:
		return &inst{0x57, 0x0, 0x0, 0x0, 320, 0xa}
	case AVMINVX:
		return &inst{0x57, 0x4, 0x0, 0x0, 320, 0xa}
	case AVMINUVV:
		return &inst{0x57, 0x0, 0x0, 0x0, 256, 0x8}
	case AVMINUVX:
		return &inst{0x57, 0x4, 0x0, 0x0, 256, 0x8}
	case AVMNANDMM:
		return &inst{0x57, 0x2, 0x0, 0x0, 1888, 0x3b}
	case AVMNORMM:
		return &inst{0x57, 0x2, 0x0, 0x0, 1952, 0x3d}
	case AVMORMM:
		return &inst{0x57, 0x2, 0x0, 0x0, 1696, 0x35}
	case AVMORNMM:
		return &inst{0x57, 0x2, 0x0, 0x0, 1824, 0x39}
	case AVMSBCVV:
		return &inst{0x57, 0x0, 0x0, 0x0, 1248, 0x27}
	case AVMSBCVVM:
		return &inst{0x57, 0x0, 0x0, 0x0, 1216, 0x26}
	case AVMSBCVX:
		return &inst{0x57, 0x4, 0x0, 0x0, 1248, 0x27}
	case AVMSBCVXM:
		return &inst{0x57, 0x4, 0x0, 0x0, 1216, 0x26}
	case AVMSBFM:
		return &inst{0x57, 0x2, 0x1, 0x0, 1280, 0x28}
	case AVMSEQVI:
		return &inst{0x57, 0x3, 0x0, 0x0, 1536, 0x30}
	case AVMSEQVV:
		return &inst{0x57, 0x0, 0x0, 0x0, 1536, 0x30}
	case AVMSEQVX:
		return &inst{0x57, 0x4, 0x0, 0x0, 1536, 0x30}
	case AVMSGTVI:
		return &inst{0x57, 0x3, 0x0, 0x0, 1984, 0x3e}
	case AVMSGTVX:
		return &inst{0x57, 0x4, 0x0, 0x0, 1984, 0x3e}
	case AVMSGTUVI:
		return &inst{0x57, 0x3, 0x0, 0x0, 1920, 0x3c}
	case AVMSGTUVX:
		return &inst{0x57, 0x4, 0x0, 0x0, 1920, 0x3c}
	case AVMSIFM:
		return &inst{0x57, 0x2, 0x3, 0x0, 1280, 0x28}
	case AVMSLEVI:
		return &inst{0x57, 0x3, 0x0, 0x0, 1856, 0x3a}
	case AVMSLEVV:
		return &inst{0x57, 0x0, 0x0, 0x0, 1856, 0x3a}
	case AVMSLEVX:
		return &inst{0x57, 0x4, 0x0, 0x0, 1856, 0x3a}
	case AVMSLEUVI:
		return &inst{0x57, 0x3, 0x0, 0x0, 1792, 0x38}
	case AVMSLEUVV:
		return &inst{0x57, 0x0, 0x0, 0x0, 1792, 0x38}
	case AVMSLEUVX:
		return &inst{0x57, 0x4, 0x0, 0x0, 1792, 0x38}
	case AVMSLTVV:
		return &inst{0x57, 0x0, 0x0, 0x0, 1728, 0x36}
	case AVMSLTVX:
		return &inst{0x57, 0x4, 0x0, 0x0, 1728, 0x36}
	case AVMSLTUVV:
		return &inst{0x57, 0x0, 0x0, 0x0, 1664, 0x34}
	case AVMSLTUVX:
		return &inst{0x57, 0x4, 0x0, 0x0, 1664, 0x34}
	case AVMSNEVI:
		return &inst{0x57, 0x3, 0x0, 0x0, 1600, 0x32}
	case AVMSNEVV:
		return &inst{0x57, 0x0, 0x0, 0x0, 1600, 0x32}
	case AVMSNEVX:
		return &inst{0x57, 0x4, 0x0, 0x0, 1600, 0x32}
	case AVMSOFM:
		return &inst{0x57, 0x2, 0x2, 0x0, 1280, 0x28}
	case AVMULVV:
		return &inst{0x57, 0x2, 0x0, 0x0, -1728, 0x4a}
	case AVMULVX:
		return &inst{0x57, 0x6, 0x0, 0x0, -1728, 0x4a}
	case AVMULHVV:
		return &inst{0x57, 0x2, 0x0, 0x0, -1600, 0x4e}
	case AVMULHVX:
		return &inst{0x57, 0x6, 0x0, 0x0, -1600, 0x4e}
	case AVMULHSUVV:
		return &inst{0x57, 0x2, 0x0, 0x0, -1664, 0x4c}
	case AVMULHSUVX:
		return &inst{0x57, 0x6, 0x0, 0x0, -1664, 0x4c}
	case AVMULHUVV:
		return &inst{0x57, 0x2, 0x0, 0x0, -1792, 0x48}
	case AVMULHUVX:
		return &inst{0x57, 0x6, 0x0, 0x0, -1792, 0x48}
	case AVMV1RV:
		return &inst{0x57, 0x3, 0x0, 0x0, -1568, 0x4f}
	case AVMV2RV:
		return &inst{0x57, 0x3, 0x1, 0x0, -1568, 0x4f}
	case AVMV4RV:
		return &inst{0x57, 0x3, 0x3, 0x0, -1568, 0x4f}
	case AVMV8RV:
		return &inst{0x57, 0x3, 0x7, 0x0, -1568, 0x4f}
	case AVMVSX:
		return &inst{0x57, 0x6, 0x0, 0x0, 1056, 0x21}
	case AVMVVI:
		return &inst{0x57, 0x3, 0x0, 0x0, 1504, 0x2f}
	case AVMVVV:
		return &inst{0x57, 0x0, 0x0, 0x0, 1504, 0x2f}
	case AVMVVX:
		return &inst{0x57, 0x4, 0x0, 0x0, 1504, 0x2f}
	case AVMVXS:
		return &inst{0x57, 0x2, 0x0, 0x0, 1056, 0x21}
	case AVMXNORMM:
		return &inst{0x57, 0x2, 0x0, 0x0, 2016, 0x3f}
	case AVMXORMM:
		return &inst{0x57, 0x2, 0x0, 0x0, 1760, 0x37}
	case AVNCLIPWI:
		return &inst{0x57, 0x3, 0x0, 0x0, -1088, 0x5e}
	case AVNCLIPWV:
		return &inst{0x57, 0x0, 0x0, 0x0, -1088, 0x5e}
	case AVNCLIPWX:
		return &inst{0x57, 0x4, 0x0, 0x0, -1088, 0x5e}
	case AVNCLIPUWI:
		return &inst{0x57, 0x3, 0x0, 0x0, -1152, 0x5c}
	case AVNCLIPUWV:
		return &inst{0x57, 0x0, 0x0, 0x0, -1152, 0x5c}
	case AVNCLIPUWX:
		return &inst{0x57, 0x4, 0x0, 0x0, -1152, 0x5c}
	case AVNMSACVV:
		return &inst{0x57, 0x2, 0x0, 0x0, -1088, 0x5e}
	case AVNMSACVX:
		return &inst{0x57, 0x6, 0x0, 0x0, -1088, 0x5e}
	case AVNMSUBVV:
		return &inst{0x57, 0x2, 0x0, 0x0, -1344, 0x56}
	case AVNMSUBVX:
		return &inst{0x57, 0x6, 0x0, 0x0, -1344, 0x56}
	case AVNSRAWI:
		return &inst{0x57, 0x3, 0x0, 0x0, -1216, 0x5a}
	case AVNSRAWV:
		return &inst{0x57, 0x0, 0x0, 0x0, -1216, 0x5a}
	case AVNSRAWX:
		return &inst{0x57, 0x4, 0x0, 0x0, -1216, 0x5a}
	case AVNSRLWI:
		return &inst{0x57, 0x3, 0x0, 0x0, -1280, 0x58}
	case AVNSRLWV:
		return &inst{0x57, 0x0, 0x0, 0x0, -1280, 0x58}
	case AVNSRLWX:
		return &inst{0x57, 0x4, 0x0, 0x0, -1280, 0x58}
	case AVORVI:
		return &inst{0x57, 0x3, 0x0, 0x0, 640, 0x14}
	case AVORVV:
		return &inst{0x57, 0x0, 0x0, 0x0, 640, 0x14}
	case AVORVX:
		return &inst{0x57, 0x4, 0x0, 0x0, 640, 0x14}
	case AVREDANDVS:
		return &inst{0x57, 0x2, 0x0, 0x0, 64, 0x2}
	case AVREDMAXVS:
		return &inst{0x57, 0x2, 0x0, 0x0, 448, 0xe}
	case AVREDMAXUVS:
		return &inst{0x57, 0x2, 0x0, 0x0, 384, 0xc}
	case AVREDMINVS:
		return &inst{0x57, 0x2, 0x0, 0x0, 320, 0xa}
	case AVREDMINUVS:
		return &inst{0x57, 0x2, 0x0, 0x0, 256, 0x8}
	case AVREDORVS:
		return &inst{0x57, 0x2, 0x0, 0x0, 128, 0x4}
	case AVREDSUMVS:
		return &inst{0x57, 0x2, 0x0, 0x0, 0, 0x0}
	case AVREDXORVS:
		return &inst{0x57, 0x2, 0x0, 0x0, 192, 0x6}
	case AVREMVV:
		return &inst{0x57, 0x2, 0x0, 0x0, -1856, 0x46}
	case AVREMVX:
		return &inst{0x57, 0x6, 0x0, 0x0, -1856, 0x46}
	case AVREMUVV:
		return &inst{0x57, 0x2, 0x0, 0x0, -1920, 0x44}
	case AVREMUVX:
		return &inst{0x57, 0x6, 0x0, 0x0, -1920, 0x44}
	case AVRGATHERVI:
		return &inst{0x57, 0x3, 0x0, 0x0, 768, 0x18}
	case AVRGATHERVV:
		return &inst{0x57, 0x0, 0x0, 0x0, 768, 0x18}
	case AVRGATHERVX:
		return &inst{0x57, 0x4, 0x0, 0x0, 768, 0x18}
	case AVRGATHEREI16VV:
		return &inst{0x57, 0x0, 0x0, 0x0, 896, 0x1c}
	case AVRSUBVI:
		return &inst{0x57, 0x3, 0x0, 0x0, 192, 0x6}
	case AVRSUBVX:
		return &inst{0x57, 0x4, 0x0, 0x0, 192, 0x6}
	case AVS1RV:
		return &inst{0x27, 0x0, 0x0, 0x8, 40, 0x1}
	case AVS2RV:
		return &inst{0x27, 0x0, 0x0, 0x8, 552, 0x11}
	case AVS4RV:
		return &inst{0x27, 0x0, 0x0, 0x8, 1576, 0x31}
	case AVS8RV:
		return &inst{0x27, 0x0, 0x0, 0x8, -472, 0x71}
	case AVSADDVI:
		return &inst{0x57, 0x3, 0x0, 0x0, -1984, 0x42}
	case AVSADDVV:
		return &inst{0x57, 0x0, 0x0, 0x0, -1984, 0x42}
	case AVSADDVX:
		return &inst{0x57, 0x4, 0x0, 0x0, -1984, 0x42}
	case AVSADDUVI:
		return &inst{0x57, 0x3, 0x0, 0x0, -2048, 0x40}
	case AVSADDUVV:
		return &inst{0x57, 0x0, 0x0, 0x0, -2048, 0x40}
	case AVSADDUVX:
		return &inst{0x57, 0x4, 0x0, 0x0, -2048, 0x40}
	case AVSBCVVM:
		return &inst{0x57, 0x0, 0x0, 0x0, 1152, 0x24}
	case AVSBCVXM:
		return &inst{0x57, 0x4, 0x0, 0x0, 1152, 0x24}
	case AVSE16V:
		return &inst{0x27, 0x5, 0x0, 0x0, 0, 0x0}
	case AVSE32V:
		return &inst{0x27, 0x6, 0x0, 0x0, 0, 0x0}
	case AVSE64V:
		return &inst{0x27, 0x7, 0x0, 0x0, 0, 0x0}
	case AVSE8V:
		return &inst{0x27, 0x0, 0x0, 0x0, 0, 0x0}
	case AVSETIVLI:
		return &inst{0x57, 0x7, 0x0, 0x0, -1024, 0x60}
	case AVSETVL:
		return &inst{0x57, 0x7, 0x0, 0x0, -2048, 0x40}
	case AVSETVLI:
		return &inst{0x57, 0x7, 0x0, 0x0, 0, 0x0}
	case AVSEXTVF2:
		return &inst{0x57, 0x2, 0x7, 0x0, 1152, 0x24}
	case AVSEXTVF4:
		return &inst{0x57, 0x2, 0x5, 0x0, 1152, 0x24}
	case AVSEXTVF8:
		return &inst{0x57, 0x2, 0x3, 0x0, 1152, 0x24}
	case AVSLIDE1DOWNVX:
		return &inst{0x57, 0x6, 0x0, 0x0, 960, 0x1e}
	case AVSLIDE1UPVX:
		return &inst{0x57, 0x6, 0x0, 0x0, 896, 0x1c}
	case AVSLIDEDOWNVI:
		return &inst{0x57, 0x3, 0x0, 0x0, 960, 0x1e}
	case AVSLIDEDOWNVX:
		return &inst{0x57, 0x4, 0x0, 0x0, 960, 0x1e}
	case AVSLIDEUPVI:
		return &inst{0x57, 0x3, 0x0, 0x0, 896, 0x1c}
	case AVSLIDEUPVX:
		return &inst{0x57, 0x4, 0x0, 0x0, 896, 0x1c}
	case AVSLLVI:
		return &inst{0x57, 0x3, 0x0, 0x0, -1728, 0x4a}
	case AVSLLVV:
		return &inst{0x57, 0x0, 0x0, 0x0, -1728, 0x4a}
	case AVSLLVX:
		return &inst{0x57, 0x4, 0x0, 0x0, -1728, 0x4a}
	case AVSMV:
		return &inst{0x27, 0x0, 0x0, 0xb, 43, 0x1}
	case AVSMULVV:
		return &inst{0x57, 0x0, 0x0, 0x0, -1600, 0x4e}
	case AVSMULVX:
		return &inst{0x57, 0x4, 0x0, 0x0, -1600, 0x4e}
	case AVSOXEI16V:
		return &inst{0x27, 0x5, 0x0, 0x0, 192, 0x6}
	case AVSOXEI32V:
		return &inst{0x27, 0x6, 0x0, 0x0, 192, 0x6}
	case AVSOXEI64V:
		return &inst{0x27, 0x7, 0x0, 0x0, 192, 0x6}
	case AVSOXEI8V:
		return &inst{0x27, 0x0, 0x0, 0x0, 192, 0x6}
	case AVSRAVI:
		return &inst{0x57, 0x3, 0x0, 0x0, -1472, 0x52}
	case AVSRAVV:
		return &inst{0x57, 0x0, 0x0, 0x0, -1472, 0x52}
	case AVSRAVX:
		return &inst{0x57, 0x4, 0x0, 0x0, -1472, 0x52}
	case AVSRLVI:
		return &inst{0x57, 0x3, 0x0, 0x0, -1536, 0x50}
	case AVSRLVV:
		return &inst{0x57, 0x0, 0x0, 0x0, -1536, 0x50}
	case AVSRLVX:
		return &inst{0x57, 0x4, 0x0, 0x0, -1536, 0x50}
	case AVSSE16V:
		return &inst{0x27, 0x5, 0x0, 0x0, 128, 0x4}
	case AVSSE32V:
		return &inst{0x27, 0x6, 0x0, 0x0, 128, 0x4}
	case AVSSE64V:
		return &inst{0x27, 0x7, 0x0, 0x0, 128, 0x4}
	case AVSSE8V:
		return &inst{0x27, 0x0, 0x0, 0x0, 128, 0x4}
	case AVSSRAVI:
		return &inst{0x57, 0x3, 0x0, 0x0, -1344, 0x56}
	case AVSSRAVV:
		return &inst{0x57, 0x0, 0x0, 0x0, -1344, 0x56}
	case AVSSRAVX:
		return &inst{0x57, 0x4, 0x0, 0x0, -1344, 0x56}
	case AVSSRLVI:
		return &inst{0x57, 0x3, 0x0, 0x0, -1408, 0x54}
	case AVSSRLVV:
		return &inst{0x57, 0x0, 0x0, 0x0, -1408, 0x54}
	case AVSSRLVX:
		return &inst{0x57, 0x4, 0x0, 0x0, -1408, 0x54}
	case AVSSUBVV:
		return &inst{0x57, 0x0, 0x0, 0x0, -1856, 0x46}
	case AVSSUBVX:
		return &inst{0x57, 0x4, 0x0, 0x0, -1856, 0x46}
	case AVSSUBUVV:
		return &inst{0x57, 0x0, 0x0, 0x0, -1920, 0x44}
	case AVSSUBUVX:
		return &inst{0x57, 0x4, 0x0, 0x0, -1920, 0x44}
	case AVSUBVV:
		return &inst{0x57, 0x0, 0x0, 0x0, 128, 0x4}
	case AVSUBVX:
		return &inst{0x57, 0x4, 0x0, 0x0, 128, 0x4}
	case AVSUXEI16V:
		return &inst{0x27, 0x5, 0x0, 0x0, 64, 0x2}
	case AVSUXEI32V:
		return &inst{0x27, 0x6, 0x0, 0x0, 64, 0x2}
	case AVSUXEI64V:
		return &inst{0x27, 0x7, 0x0, 0x0, 64, 0x2}
	case AVSUXEI8V:
		return &inst{0x27, 0x0, 0x0, 0x0, 64, 0x2}
	case AVWADDVV:
		return &inst{0x57, 0x2, 0x0, 0x0, -960, 0x62}
	case AVWADDVX:
		return &inst{0x57, 0x6, 0x0, 0x0, -960, 0x62}
	case AVWADDWV:
		return &inst{0x57, 0x2, 0x0, 0x0, -704, 0x6a}
	case AVWADDWX:
		return &inst{0x57, 0x6, 0x0, 0x0, -704, 0x6a}
	case AVWADDUVV:
		return &inst{0x57, 0x2, 0x0, 0x0, -1024, 0x60}
	case AVWADDUVX:
		return &inst{0x57, 0x6, 0x0, 0x0, -1024, 0x60}
	case AVWADDUWV:
		return &inst{0x57, 0x2, 0x0, 0x0, -768, 0x68}
	case AVWADDUWX:
		return &inst{0x57, 0x6, 0x0, 0x0, -768, 0x68}
	case AVWMACCVV:
		return &inst{0x57, 0x2, 0x0, 0x0, -192, 0x7a}
	case AVWMACCVX:
		return &inst{0x57, 0x6, 0x0, 0x0, -192, 0x7a}
	case AVWMACCSUVV:
		return &inst{0x57, 0x2, 0x0, 0x0, -64, 0x7e}
	case AVWMACCSUVX:
		return &inst{0x57, 0x6, 0x0, 0x0, -64, 0x7e}
	case AVWMACCUVV:
		return &inst{0x57, 0x2, 0x0, 0x0, -256, 0x78}
	case AVWMACCUVX:
		return &inst{0x57, 0x6, 0x0, 0x0, -256, 0x78}
	case AVWMACCUSVX:
		return &inst{0x57, 0x6, 0x0, 0x0, -128, 0x7c}
	case AVWMULVV:
		return &inst{0x57, 0x2, 0x0, 0x0, -320, 0x76}
	case AVWMULVX:
		return &inst{0x57, 0x6, 0x0, 0x0, -320, 0x76}
	case AVWMULSUVV:
		return &inst{0x57, 0x2, 0x0, 0x0, -384, 0x74}
	case AVWMULSUVX:
		return &inst{0x57, 0x6, 0x0, 0x0, -384, 0x74}
	case AVWMULUVV:
		return &inst{0x57, 0x2, 0x0, 0x0, -512, 0x70}
	case AVWMULUVX:
		return &inst{0x57, 0x6, 0x0, 0x0, -512, 0x70}
	case AVWREDSUMVS:
		return &inst{0x57, 0x0, 0x0, 0x0, -960, 0x62}
	case AVWREDSUMUVS:
		return &inst{0x57, 0x0, 0x0, 0x0, -1024, 0x60}
	case AVWSUBVV:
		return &inst{0x57, 0x2, 0x0, 0x0, -832, 0x66}
	case AVWSUBVX:
		return &inst{0x57, 0x6, 0x0, 0x0, -832, 0x66}
	case AVWSUBWV:
		return &inst{0x57, 0x2, 0x0, 0x0, -576, 0x6e}
	case AVWSUBWX:
		return &inst{0x57, 0x6, 0x0, 0x0, -576, 0x6e}
	case AVWSUBUVV:
		return &inst{0x57, 0x2, 0x0, 0x0, -896, 0x64}
	case AVWSUBUVX:
		return &inst{0x57, 0x6, 0x0, 0x0, -896, 0x64}
	case AVWSUBUWV:
		return &inst{0x57, 0x2, 0x0, 0x0, -640, 0x6c}
	case AVWSUBUWX:
		return &inst{0x57, 0x6, 0x0, 0x0, -640, 0x6c}
	case AVXORVI:
		return &inst{0x57, 0x3, 0x0, 0x0, 704, 0x16}
	case AVXORVV:
		return &inst{0x57, 0x0, 0x0, 0x0, 704, 0x16}
	case AVXORVX:
		return &inst{0x57, 0x4, 0x0, 0x0, 704, 0x16}
	case AVZEXTVF2:
		return &inst{0x57, 0x2, 0x6, 0x0, 1152, 0x24}
	case AVZEXTVF4:
		return &inst{0x57, 0x2, 0x4, 0x0, 1152, 0x24}
	case AVZEXTVF8:
		return &inst{0x57, 0x2, 0x2, 0x0, 1152, 0x24}
	case AWFI:
		return &inst{0x73, 0x0, 0x0, 0x5, 261, 0x8}
	case AXNOR:
		return &inst{0x33, 0x4, 0x0, 0x0, 1024, 0x20}
	case AXOR:
		return &inst{0x33, 0x4, 0x0, 0x0, 0, 0x0}
	case AXORI:
		return &inst{0x13, 0x4, 0x0, 0x0, 0, 0x0}
	case AZEXTH:
		return &inst{0x3b, 0x4, 0x0, 0x0, 128, 0x4}
	}
	return nil
}
